import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";
import { Toaster } from "@/components/ui/toaster";

const inter = Inter({
  subsets: ["latin"],
  variable: "--font-inter",
});

export const metadata: Metadata = {
  title: "سیستم مدیریت بایگانی سایت‌ها و هاست‌ها",
  description: "سیستم جامع مدیریت بایگانی سایت‌ها و هاست‌ها با تفکیک بر اساس آدرس IP",
  keywords: ["بایگانی", "سایت", "هاست", "IP", "مدیریت", "Cloudflare", "DNS"],
  authors: [{ name: "Archive Management Team" }],
  icons: {
    icon: "/favicon.ico",
  },
  openGraph: {
    title: "سیستم مدیریت بایگانی",
    description: "سیستم جامع مدیریت بایگانی سایت‌ها و هاست‌ها",
    type: "website",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="fa" dir="rtl" suppressHydrationWarning>
      <head>
        <link rel="preconnect" href="https://fonts.googleapis.com" />
        <link rel="preconnect" href="https://fonts.gstatic.com" crossOrigin="" />
        <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet" />
      </head>
      <body
        className={`${inter.variable} font-sans antialiased bg-background text-foreground`}
        style={{ fontFamily: 'Vazirmatn, sans-serif' }}
      >
        {children}
        <Toaster />
      </body>
    </html>
  );
}
