import { NextRequest, NextResponse } from 'next/server';

// Mock data for demonstration
const mockStats = {
  total_websites: 4,
  active_websites: 3,
  redirected_websites: 1,
  total_hosts: 4,
  active_hosts: 3,
  unique_ips: 5,
  total_dns_records: 4,
  cloudflare_accounts: 4,
  total_domains: 4,
  proxied_domains: 2
};

const mockIpDistribution = [
  {
    ip_address: '192.168.1.100',
    total_websites: 1,
    total_hosts: 1,
    total_items: 2
  },
  {
    ip_address: '192.168.1.101',
    total_websites: 1,
    total_hosts: 1,
    total_items: 2
  },
  {
    ip_address: '192.168.1.102',
    total_websites: 1,
    total_hosts: 0,
    total_items: 1
  },
  {
    ip_address: '192.168.1.103',
    total_websites: 1,
    total_hosts: 0,
    total_items: 1
  },
  {
    ip_address: '192.168.1.200',
    total_websites: 0,
    total_hosts: 1,
    total_items: 1
  }
];

const mockWebsites = [
  {
    id: 1,
    name: 'سایت اصلی شرکت',
    domain: 'main-company.com',
    ip_address: '192.168.1.100',
    description: 'وبسایت اصلی شرکت با تمام خدمات',
    status: 'active',
    created_at: new Date().toISOString()
  },
  {
    id: 2,
    name: 'فروشگاه آنلاین',
    domain: 'shop.example.com',
    ip_address: '192.168.1.101',
    description: 'فروشگاه آنلاین محصولات',
    status: 'active',
    created_at: new Date().toISOString()
  },
  {
    id: 3,
    name: 'وبلاگ فنی',
    domain: 'blog.techsite.com',
    ip_address: '192.168.1.102',
    description: 'وبلاگ تخصصی فنی و آموزشی',
    status: 'active',
    created_at: new Date().toISOString()
  },
  {
    id: 4,
    name: 'پورتال مشتریان',
    domain: 'portal.client.com',
    ip_address: '192.168.1.103',
    description: 'پورتال مدیریت مشتریان',
    status: 'inactive',
    created_at: new Date().toISOString()
  }
];

const mockHosts = [
  {
    id: 1,
    name: 'سرور اصلی',
    ip_address: '192.168.1.100',
    provider: 'DigitalOcean',
    location: 'آمستردام',
    specs: 'CPU: 4Core, RAM: 8GB, SSD: 160GB',
    status: 'active',
    created_at: new Date().toISOString()
  },
  {
    id: 2,
    name: 'سرور فروشگاه',
    ip_address: '192.168.1.101',
    provider: 'Vultr',
    location: 'فرانکفورت',
    specs: 'CPU: 2Core, RAM: 4GB, SSD: 80GB',
    status: 'active',
    created_at: new Date().toISOString()
  },
  {
    id: 3,
    name: 'سرور پشتیبان',
    ip_address: '192.168.1.200',
    provider: 'Hetzner',
    location: 'نورنبرگ',
    specs: 'CPU: 8Core, RAM: 16GB, SSD: 320GB',
    status: 'maintenance',
    created_at: new Date().toISOString()
  },
  {
    id: 4,
    name: 'سرور توسعه',
    ip_address: '192.168.1.201',
    provider: 'Linode',
    location: 'لندن',
    specs: 'CPU: 2Core, RAM: 2GB, SSD: 40GB',
    status: 'active',
    created_at: new Date().toISOString()
  }
];

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url);
    const type = searchParams.get('type');

    let data = {};
    
    switch (type) {
      case 'stats':
        data = mockStats;
        break;
      case 'ipDistribution':
        data = mockIpDistribution;
        break;
      case 'websites':
        data = mockWebsites;
        break;
      case 'hosts':
        data = mockHosts;
        break;
      default:
        data = {
          stats: mockStats,
          ipDistribution: mockIpDistribution,
          websites: mockWebsites,
          hosts: mockHosts
        };
    }

    return NextResponse.json({
      success: true,
      message: 'Dashboard data retrieved successfully',
      data
    });
  } catch (error) {
    console.error('Dashboard API Error:', error);
    return NextResponse.json(
      {
        success: false,
        message: 'Internal server error',
        error: error instanceof Error ? error.message : 'Unknown error'
      },
      { status: 500 }
    );
  }
}