CREATE DATABASE IF NOT EXISTS archive_manager;
USE archive_manager;

-- Table for storing websites with IP addresses
CREATE TABLE websites (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    domain VARCHAR(255) NOT NULL,
    ip_address VARCHAR(45) NOT NULL,
    description TEXT,
    status ENUM('active', 'inactive', 'suspended') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY unique_domain (domain),
    INDEX idx_ip (ip_address),
    INDEX idx_status (status)
);

-- Table for storing hosting information
CREATE TABLE hosts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    ip_address VARCHAR(45) NOT NULL,
    provider VARCHAR(255),
    location VARCHAR(255),
    specs TEXT,
    status ENUM('active', 'inactive', 'maintenance') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_ip (ip_address),
    INDEX idx_status (status)
);

-- Table for tracking IP usage and relationships
CREATE TABLE ip_assignments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    ip_address VARCHAR(45) NOT NULL,
    website_id INT NULL,
    host_id INT NULL,
    assignment_type ENUM('website', 'host') NOT NULL,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (website_id) REFERENCES websites(id) ON DELETE CASCADE,
    FOREIGN KEY (host_id) REFERENCES hosts(id) ON DELETE CASCADE,
    INDEX idx_ip (ip_address),
    INDEX idx_type (assignment_type)
);

-- Insert sample data
INSERT INTO websites (name, domain, ip_address, description, status) VALUES
('سایت اصلی شرکت', 'main-company.com', '192.168.1.100', 'وبسایت اصلی شرکت با تمام خدمات', 'active'),
('فروشگاه آنلاین', 'shop.example.com', '192.168.1.101', 'فروشگاه آنلاین محصولات', 'active'),
('وبلاگ فنی', 'blog.techsite.com', '192.168.1.102', 'وبلاگ تخصصی فنی و آموزشی', 'active'),
('پورتال مشتریان', 'portal.client.com', '192.168.1.103', 'پورتال مدیریت مشتریان', 'inactive');

INSERT INTO hosts (name, ip_address, provider, location, specs, status) VALUES
('سرور اصلی', '192.168.1.100', 'DigitalOcean', 'آمستردام', 'CPU: 4Core, RAM: 8GB, SSD: 160GB', 'active'),
('سرور فروشگاه', '192.168.1.101', 'Vultr', 'فرانکفورت', 'CPU: 2Core, RAM: 4GB, SSD: 80GB', 'active'),
('سرور پشتیبان', '192.168.1.200', 'Hetzner', 'نورنبرگ', 'CPU: 8Core, RAM: 16GB, SSD: 320GB', 'maintenance'),
('سرور توسعه', '192.168.1.201', 'Linode', 'لندن', 'CPU: 2Core, RAM: 2GB, SSD: 40GB', 'active');