# راهنمای راه‌اندازی سریع

## مرحله ۱: آماده‌سازی دیتابیس

۱. وارد phpMyAdmin شوید
۲. دیتابیس جدیدی با نام `archive_manager` ایجاد کنید
۳. فایل `database.sql` را وارد کنید

## مرحله ۲: تنظیمات PHP

۱. فایل `config/database.php` را باز کنید
۲. اطلاعات دیتابیس خود را وارد کنید:

```php
private $host = 'localhost';        // معمولا localhost
private $dbname = 'archive_manager'; // نام دیتابیس
private $username = 'root';         // نام کاربری دیتابیس
private $password = '';             // رمز عبور دیتابیس
```

## مرحله ۳: اجرای برنامه

### روش ۱: استفاده از سرور PHP داخلی
```bash
# در پوشه پروژه دستور زیر را اجرا کنید
php -S localhost:8000
```

### روش ۲: استفاده از XAMPP/WAMP
۱. پروژه را در پوشه `htdocs` یا `www` کپی کنید
۲. Apache را启动 کنید
۳. به آدرس `http://localhost/your-project-name` بروید

## مرحله ۴: تست کردن

۱. به آدرس `test-api.php` بروید
۲. باید پیام موفقیت‌آمیز بودن را مشاهده کنید
۳. سپس به `index.html` بروید

## مشکلات رایج

### خطای اتصال به دیتابیس
- بررسی کنید که MySQL در حال اجرا باشد
- اطلاعات دیتابیس را در `config/database.php` بررسی کنید
- مطمئن شوید دیتابیس `archive_manager` وجود دارد

### خطای CORS
- فایل `.htaccess` باید در پوشه اصلی باشد
- مطمئن شوید ماژول `mod_headers` در Apache فعال است

### خطای 404
- بررسی کنید که فایل‌ها در مسیر درست قرار دارند
- آدرس‌دهی API را بررسی کنید

## ویژگی‌های سیستم

✅ **مدیریت سایت‌ها**: افزودن، ویرایش، حذف سایت‌ها با IP
✅ **مدیریت هاست‌ها**: مدیریت سرورها و مشخصات فنی
✅ **داشبورد**: آمار و نمودارهای بصری
✅ **جستجو**: جستجوی پیشرفته در تمام اطلاعات
✅ **تفکیک IP**: مشاهده سایت‌ها و هاست‌های هر IP
✅ **رابط کاربری**: مدرن، واکنش‌گرا و فارسی

## شروع کار

1. **داشبورد**: مشاهده آمار کلی و فعالیت‌های اخیر
2. **سایت‌ها**: مدیریت وبسایت‌ها و دامنه‌ها
3. **هاست‌ها**: مدیریت سرورها و ارائه‌دهندگان
4. **مدیریت IP**: تفکیک و مشاهده بر اساس آدرس IP

## نکات فنی

- سیستم از RESTful API استفاده می‌کند
- تمام درخواست‌ها با JSON پاسخ داده می‌شوند
- از Prepared Statements برای امنیت استفاده شده
- طراحی کاملاً واکنش‌گرا و مناسب موبایل