# سیستم مدیریت بایگانی سایت‌ها و هاست‌ها

یک ابزار کامل برای مدیریت و بایگانی سایت‌ها و هاست‌ها با تفکیک بر اساس آدرس IP

## ویژگی‌ها

### 🌐 مدیریت سایت‌ها
- افزودن، ویرایش و حذف سایت‌ها
- ثبت دامنه و آدرس IP
- مدیریت وضعیت سایت (فعال/غیرفعال/مسدود)
- توضیحات و اطلاعات تکمیلی

### 🖥️ مدیریت هاست‌ها
- افزودن، ویرایش و حذف هاست‌ها
- ثبت ارائه‌دهنده و موقعیت سرور
- مشخصات فنی سرور
- مدیریت وضعیت هاست

### 📊 داشبورد مدیریتی
- آمار کلی سایت‌ها و هاست‌ها
- نمایش توزیع IP ها
- فعالیت‌های اخیر
- نمودارهای بصری

### 🔍 جستجوی پیشرفته
- جستجو در تمام فیلدها
- فیلتر بر اساس IP
- نتایج فوری و دقیق

### 📱 رابط کاربری مدرن
- طراحی واکنش‌گرا (Responsive)
- پشتیبانی از زبان فارسی و RTL
- انیمیشن‌های روان
- پشتیبانی از موبایل

## نیازمندی‌ها

- PHP 7.4 یا بالاتر
- MySQL 5.7 یا بالاتر
- وب‌سرور (Apache/Nginx)

## نصب و راه‌اندازی

### ۱. ایجاد دیتابیس
```sql
CREATE DATABASE archive_manager;
```

### ۲. وارد کردن جداول
فایل `database.sql` را در دیتابیس خود وارد کنید:
```bash
mysql -u username -p archive_manager < database.sql
```

### ۳. تنظیمات دیتابیس
فایل `config/database.php` را باز کرده و اطلاعات دیتابیس خود را وارد کنید:
```php
private $host = 'localhost';
private $dbname = 'archive_manager';
private $username = 'your_username';
private $password = 'your_password';
```

### ۴. دسترسی به وب‌سرور
پروژه را در وب‌سرور خود قرار دهید و به آدرس `index.html` دسترسی داشته باشید.

## ساختار پروژه

```
project/
├── index.html              # صفحه اصلی
├── app.js                  # جاوااسکریپت فرانت‌اند
├── config/
│   └── database.php        # تنظیمات دیتابیس
├── api/
│   ├── websites.php        # API مدیریت سایت‌ها
│   ├── hosts.php           # API مدیریت هاست‌ها
│   └── dashboard.php       # API داشبورد
└── database.sql            # ساختار دیتابیس
```

## API ها

### سایت‌ها
- `GET /api/websites.php` - دریافت تمام سایت‌ها
- `GET /api/websites.php?id={id}` - دریافت سایت مشخص
- `POST /api/websites.php` - ایجاد سایت جدید
- `PUT /api/websites.php?id={id}` - ویرایش سایت
- `DELETE /api/websites.php?id={id}` - حذف سایت

### هاست‌ها
- `GET /api/hosts.php` - دریافت تمام هاست‌ها
- `GET /api/hosts.php?id={id}` - دریافت هاست مشخص
- `POST /api/hosts.php` - ایجاد هاست جدید
- `PUT /api/hosts.php?id={id}` - ویرایش هاست
- `DELETE /api/hosts.php?id={id}` - حذف هاست

### داشبورد
- `GET /api/dashboard.php?stats=1` - آمار کلی
- `GET /api/dashboard.php?ip_distribution=1` - توزیع IP ها
- `GET /api/dashboard.php?recent_activity=1` - فعالیت‌های اخیر
- `GET /api/dashboard.php?search={query}` - جستجو

## استفاده از سیستم

### ۱. داشبورد
پس از ورود به سیستم، داشبورد اصلی را مشاهده می‌کنید که شامل:
- آمار کلی سایت‌ها و هاست‌ها
- توزیع IP ها با نمودارهای بصری
- فعالیت‌های اخیر سیستم

### ۲. مدیریت سایت‌ها
از منوی سمت راست، گزینه "سایت‌ها" را انتخاب کنید:
- برای افزودن سایت جدید، روی دکمه "افزودن سایت" کلیک کنید
- برای ویرایش، روی دکمه ویرایش در کنار هر سایت کلیک کنید
- برای حذف، روی دکمه حذف کلیک کنید

### ۳. مدیریت هاست‌ها
از منوی سمت راست، گزینه "هاست‌ها" را انتخاب کنید:
- فرآیند مشابه مدیریت سایت‌ها
- اطلاعات تکمیلی مانند ارائه‌دهنده و موقعیت

### ۴. مدیریت IP
از منوی سمت راست، گزینه "مدیریت IP" را انتخاب کنید:
- مشاهده تمام IP ها و موارد مرتبط
- تفکیک سایت‌ها و هاست‌های هر IP
- دسترسی سریع به جزئیات

### ۵. جستجو
از نوار جستجوی بالای صفحه برای:
- جستجو در نام سایت‌ها و هاست‌ها
- جستجو بر اساس آدرس IP
- جستجو در توضیحات و مشخصات

## ویژگی‌های فنی

- **فرانت‌اند**: HTML5, CSS3, JavaScript (ES6+)
- **استایل**: Tailwind CSS, Font Awesome
- **بک‌اند**: PHP 7.4+, PDO
- **دیتابیس**: MySQL
- **API**: RESTful API با JSON
- **امنیت**: Prepared Statements, CORS Headers

## پشتیبانی از موبایل
سیستم به طور کامل روی دستگاه‌های موبایل و تبلت کار می‌کند و دارای:
- منوی همبرگر برای موبایل
- طراحی واکنش‌گرا
- لمس‌فرند بودن تمام عناصر

## سفارشی‌سازی

### تغییر رنگ‌ها
در فایل `index.html`، متغیرهای CSS را تغییر دهید:
```css
:root {
    --primary-color: #3b82f6;
    --secondary-color: #10b981;
    --danger-color: #ef4444;
}
```

### افزودن فیلدهای جدید
1. تغییر ساختار دیتابیس در `database.sql`
2. به‌روزرسانی API های مربوطه
3. افزودن فیلدها به فرم‌ها در `index.html`
4. به‌روزرسانی توابع جاوااسکریپت در `app.js`

## خطایابی

### مشکلات رایج
1. **ارتباط با دیتابیس**: بررسی اطلاعات دیتابیس در `config/database.php`
2. **مشکلات API**: بررسی لاگ‌های خطا در کنسول مرورگر
3. **مشکلات نمایش**: بررسی سازگاری مرورگر

### لاگ‌ها
برای مشاهده خطاها، کنسول توسعه‌دهنده مرورگر را باز کنید (F12).

## مجوز
این پروژه تحت مجوز MIT منتشر شده است.

## پشتیبانی
در صورت بروز هرگونه مشکل، از طریق بخش Issues در گیت‌هاب با ما در تماس باشید.