# سیستم مدیریت بایگانی سایت‌ها و هاست‌ها (نسخه Next.js)

یک ابزار کامل و مدرن برای مدیریت و بایگانی سایت‌ها و هاست‌ها با تفکیک بر اساس آدرس IP، ساخته شده با Next.js 15 و TypeScript.

## 🌟 ویژگی‌ها

### 📊 داشبورد مدیریتی
- **آمار زنده**: نمایش کل سایت‌ها، هاست‌ها و IP های منحصر به فرد
- **نمودارهای بصری**: توزیع IP ها با نمودارهای زیبا
- **رابط کاربری مدرن**: طراحی با Tailwind CSS و شیدکن/تم تیره
- **واکنش‌گرا**: کارایی عالی روی تمام دستگاه‌ها

### 🌐 مدیریت سایت‌ها
- **CRUD کامل**: افزودن، ویرایش، حذف و مشاهده سایت‌ها
- **تفکیک بر اساس IP**: نمایش خودکار سایت‌های هر IP
- **وضعیت‌ها**: فعال، غیرفعال، مسدود
- **جستجوی پیشرفته**: جستجو در تمام فیلدها

### 🖥️ مدیریت هاست‌ها
- **مدیریت سرورها**: افزودن و ویرایش اطلاعات هاست‌ها
- **مشخصات فنی**: ارائه‌دهنده، موقعیت، مشخصات سخت‌افزاری
- **وضعیت‌ها**: فعال، غیرفعال، در حال تعمیر
- **پیوند IP**: اتصال هاست‌ها به IP های مربوطه

### 🔍 جستجو و فیلتر
- **جستجوی جهانی**: جستجو در تمام سایت‌ها و هاست‌ها
- **فیلتر بر اساس IP**: نمایش موارد مرتبط با هر IP
- **نتایج فوری**: جستجو بدون تأخیر

### 🎨 طراحی و تجربه کاربری
- **RTL کامل**: پشتیبانی کامل از زبان فارسی
- **انیمیشن‌های روان**: انتقال‌های زیبا و طبیعی
- **مودال‌های مدرن**: فرم‌های افزودن و ویرایش زیبا
- **اعلان‌های Toast**: بازخورد فوری به کاربر

## 🛠️ تکنولوژی‌ها

- **فریمورک**: Next.js 15 با App Router
- **زبان**: TypeScript 5
- **استایل**: Tailwind CSS 4
- **آیکون‌ها**: Lucide React
- **API**: Next.js API Routes
- **موبایل**: کاملاً واکنش‌گرا

## 📋 نیازمندی‌ها

- Node.js 18 یا بالاتر
- npm یا yarn

## 🚀 نصب و راه‌اندازی

### ۱. نصب پروژه
```bash
git clone <repository-url>
cd archive-manager-nextjs
npm install
```

### ۲. اجرای توسعه
```bash
npm run dev
```

### ۳. دسترسی به برنامه
باز کنید: [http://localhost:3000](http://localhost:3000)

## 📁 ساختار پروژه

```
src/
├── app/
│   ├── page.tsx              # صفحه اصلی داشبورد
│   ├── api/
│   │   ├── dashboard/        # API داشبورد
│   │   ├── websites/         # API سایت‌ها
│   │   └── hosts/            # API هاست‌ها
│   └── layout.tsx            # لایوت اصلی
├── components/
│   └── ui/                   # کامپوننت‌های UI
└── lib/
    └── db.ts                 # اتصال به دیتابیس
```

## 🎯 نحوه استفاده

### ۱. داشبورد
- **آمار کلی**: مشاهده آمار کلی سایت‌ها و هاست‌ها
- **توزیع IP**: نمایش نموداری توزیع IP ها
- **دسترسی سریع**: دسترسی به تمام بخش‌ها

### ۲. مدیریت سایت‌ها
- **افزودن سایت**: کلیک روی دکمه "افزودن سایت"
- **ویرایش**: کلیک روی آیکون ویرایش در کنار هر سایت
- **حذف**: کلیک روی آیکون حذف با تأییدیه
- **جستجو**: استفاده از نوار جستجوی بالای صفحه

### ۳. مدیریت هاست‌ها
- **افزودن هاست**: کلیک روی دکمه "افزودن هاست"
- **مشخصات فنی**: وارد کردن اطلاعات کامل سرور
- **مدیریت وضعیت**: تغییر وضعیت هاست

### ۴. مدیریت IP
- **مشاهده توزیع**: نمایش تمام IP ها و موارد مرتبط
- **تفکیک خودکار**: نمایش سایت‌ها و هاست‌های هر IP

## 🔧 API ها

### داشبورد
```
GET /api/dashboard
GET /api/dashboard?type=stats
GET /api/dashboard?type=ipDistribution
```

### سایت‌ها
```
GET /api/websites              # دریافت تمام سایت‌ها
GET /api/websites?id={id}      # دریافت سایت مشخص
POST /api/websites             # ایجاد سایت جدید
PUT /api/websites?id={id}      # ویرایش سایت
DELETE /api/websites?id={id}   # حذف سایت
```

### هاست‌ها
```
GET /api/hosts                 # دریافت تمام هاست‌ها
GET /api/hosts?id={id}         # دریافت هاست مشخص
POST /api/hosts                # ایجاد هاست جدید
PUT /api/hosts?id={id}         # ویرایش هاست
DELETE /api/hosts?id={id}      # حذف هاست
```

## 📊 نمونه داده‌ها

برای نمایش، برنامه با داده‌های نمونه زیر راه‌اندازی می‌شود:

### سایت‌های نمونه
- سایت اصلی شرکت (192.168.1.100)
- فروشگاه آنلاین (192.168.1.101)
- وبلاگ فنی (192.168.1.102)
- پورتال مشتریان (192.168.1.103)

### هاست‌های نمونه
- سرور اصلی - DigitalOcean (192.168.1.100)
- سرور فروشگاه - Vultr (192.168.1.101)
- سرور پشتیبان - Hetzner (192.168.1.200)
- سرور توسعه - Linode (192.168.1.201)

## 🎨 ویژگی‌های طراحی

### رنگ‌بندی
- **آبی**: اصلی و اطلاعاتی
- **سبز**: موفقیت و وضعیت فعال
- **قرمز**: خطا و وضعیت غیرفعال
- **نارنجی**: هشدار و وضعیت تعمیر

### انیمیشن‌ها
- **ورود**: Fade in از پایین
- **هاور**: بزرگ شدن و سایه
- **لودینگ**: چرخش نرم
- **مودال**: slide از بالا

### واکنش‌گرایی
- **موبایل**: منوی همبرگر و طراحی تک ستونه
- **تبلت**: دو ستونه با منوی کناری
- **دسکتاپ**: چند ستونه با sidebar کامل

## 🔒 ویژگی‌های امنیتی

- **Validation**: اعتبارسنجی کامل ورودی‌ها
- **TypeScript**: امنیت نوع در کامپایل‌تایم
- **Error Handling**: مدیریت کامل خطاها
- **CORS**: تنظیمات امنیتی CORS

## 🚀 بهینه‌سازی

- **Code Splitting**: بارگذاری بهینه صفحات
- **Image Optimization**: بهینه‌سازی خودکار تصاویر
- **Bundle Analysis**: تحلیل حجم باندل
- **Performance**: امتیاز عملکردی بالا

## 📱 پشتیبانی موبایل

- **Touch Friendly**: عناصر لمسی مناسب
- **Responsive Design**: طراحی کاملاً واکنش‌گرا
- **Mobile Menu**: منوی همبرگر اختصاصی
- **Swipe Gestures**: پشتیبانی از سوایپ

## 🔮 قابلیت‌های آینده

- [ ] اتصال به دیتابیس واقعی
- [ ] احراز هویت کاربران
- [ ] экспورت داده‌ها
- [ ] نمودارهای پیشرفته‌تر
- [ ] اعلان‌های واقعی
- [ ] پشتیبانی از چند زبان

## 🤝 مشارکت

برای مشارکت در پروژه:
1. Fork کنید
2. شاخه جدید بسازید (`git checkout -b feature/AmazingFeature`)
3. تغییرات را commit کنید (`git commit -m 'Add some AmazingFeature'`)
4. به شاخه اصلی push کنید (`git push origin feature/AmazingFeature`)
5. Pull Request باز کنید

## 📄 مجوز

این پروژه تحت مجوز MIT منتشر شده است.

## 📞 پشتیبانی

برای گزارش باگ یا درخواست ویژگی جدید:
- باز کردن Issue در GitHub
- تماس با تیم توسعه

---

**توسعه داده شده با ❤️ برای مدیریت بهتر زیرساخت‌های وب**