# 🚀 راهنمای سریع نصب روی Hostinger

## 🎯 **ابتدا نوع هاستینگ خود را پیدا کنید**

### وارد Hostinger hPanel شوید و ببینید:
- **Business Hosting**؟ → روش ۱
- **VPS Hosting**؟ → روش ۲  
- **Shared Hosting**؟ → روش ۳
- **Cloud Hosting**؟ → روش ۴

---

## 🎯 **روش ۱: Business Hosting (بهترین)**

### مرحله ۱: ساخت اپلیکیشن Node.js
```
hPanel → Advanced → Node.js → Create Application
```

### تنظیمات:
```
Node.js version: 18.x
Application mode: Production
Application root: archive-manager
Application URL: /archive-manager
Application startup file: package.json
```

### مرحله ۲: آپلود فایل‌ها
```
1. File Manager → public_html
2. پوشه archive-manager بسازید
3. تمام فایل‌ها را آپلود کنید
4. Extract کنید
```

### مرحله ۳: نصب و اجرا
```
1. در Node.js Manager: Run NPM Install
2. Run NPM Build
3. Restart
4. به yourdomain.com/archive-manager بروید
```

---

## 🎯 **روش ۲: VPS Hosting**

### مرحله ۱: اتصال SSH
```bash
ssh root@your-server-ip
```

### مرحله ۲: نصب Node.js
```bash
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs
sudo npm install -g pm2
```

### مرحله ۳: آپلود و اجرا
```bash
cd /var/www/
git clone your-repo-url archive-manager
cd archive-manager
npm install
npm run build
pm2 start npm --name "archive-manager" -- start
```

---

## 🎯 **روش ۳: Shared Hosting (نسخه استاتیک)**

### مرحله ۱: تنظیم next.config.js
```javascript
const nextConfig = {
  output: 'export',
  trailingSlash: true,
  images: { unoptimized: true }
}
module.exports = nextConfig
```

### مرحله ۲: ساخت نسخه استاتیک
```bash
npm run build
npm run export
```

### مرحله ۳: آپلود
```
1. File Manager → public_html
2. پوشه archive-manager بسازید
3. محتویات out را آپلود کنید
4. به yourdomain.com/archive-manager بروید
```

---

## 🔧 **اگر خطایی دیدید:**

### خطا: "Node.js not supported"
```
→ از روش ۳ (استاتیک) استفاده کنید
```

### خطا: "Build failed"
```
→ NODE_OPTIONS='--max-old-space-size=2048' npm run build
```

### خطا: "Port blocked"
```
→ در next.config.js پورت تغییر دهید
```

---

## 🎯 **پیشنهاد من**

### اگر Business Hosting دارید:
✅ **روش ۱** - کامل و عالی

### اگر VPS دارید:
✅ **روش ۲** - کنترل کامل

### اگر Shared Hosting دارید:
✅ **روش ۳** - ساده و کارا

### اگر می‌خواهید بهترین نتیجه را بگیرید:
🚀 **Vercel** - رایگان و بی‌نقصه

---

## 📞 **کمک بیشتر**

نوع هاستینگ Hostinger شما چیست؟
- Business؟
- VPS؟  
- Shared؟
- Cloud؟

با گفتن نوع هاستینگ، می‌توانم راهنمایی دقیق‌تری بدهم!

**موفق باشید!** 🎉