# 🚀 راهنمای کامل نصب روی Hostinger

## 🎯 **روش‌های مختلف Hostinger**

Hostinger چند نوع هاست مختلف دارد:
- **Shared Hosting** (محدودیت دارد)
- **VPS Hosting** (کنترل کامل)
- **Cloud Hosting** (مدرن و قدرتمند)
- **Business Hosting** (پشتیبانی Node.js)

---

## 🏆 **روش ۱: Hostinger Business Hosting (بهترین روش)**

### مرحله ۱: بررسی پنل هاستینگ
1. وارد Hostinger hPanel شوید
2. دنبال **"Node.js"** یا **"Setup Node.js App"** بگردید
3. اگر پیدا کردید، این بهترین روش است!

### مرحله ۲: ساخت اپلیکیشن Node.js
```
hPanel → Advanced → Node.js → Create Application
```

### تنظیمات:
```
Node.js version: 18.x یا 20.x
Application mode: Production
Application root: archive-manager
Application URL: /archive-manager
Application startup file: package.json
```

### مرحله ۳: آپلود فایل‌ها
```
1. وارد File Manager شوید
2. به پوشه public_html بروید
3. پوشه archive-manager بسازید
4. تمام فایل‌های پروژه را آپلود کنید
5. فایل‌ها را Extract کنید
```

### مرحله ۴: نصب دیپندنسی‌ها
```
در hPanel → Advanced → Node.js:
1. پروژه خود را پیدا کنید
2. دکمه "Run NPM Install" را بزنید
3. صبر کنید تا نصب تمام شود
```

### مرحله ۵: ساخت و اجرا
```
1. دکمه "Run NPM Build" را بزنید
2. دکمه "Restart" را بزنید
3. به آدرس yourdomain.com/archive-manager بروید
```

---

## 🎯 **روش ۲: Hostinger VPS (کنترل کامل)**

### مرحله ۱: اتصال SSH
```bash
# اطلاعات SSH را از Hostinger بگیرید
ssh root@your-server-ip
```

### مرحله ۲: نصب Node.js
```bash
# آپدیت سرور
apt update && apt upgrade -y

# نصب Node.js 18
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# نصب PM2
sudo npm install -g pm2

# نصب Nginx
sudo apt install nginx -y
```

### مرحله ۳: آپلود پروژه
```bash
# به پوشه وب بروید
cd /var/www/

# پروژه را کلون کنید
git clone your-repo-url archive-manager
cd archive-manager

# نصب دیپندنسی‌ها
npm install

# ساخت پروژه
npm run build
```

### مرحله ۴: اجرا با PM2
```bash
# ساخت فایل ecosystem.config.js
nano ecosystem.config.js
```

محتوای فایل:
```javascript
module.exports = {
  apps: [{
    name: 'archive-manager',
    script: 'npm',
    args: 'start',
    cwd: '/var/www/archive-manager',
    instances: 'max',
    exec_mode: 'cluster',
    env: {
      NODE_ENV: 'production',
      PORT: 3000
    }
  }]
};
```

اجرای برنامه:
```bash
pm2 start ecosystem.config.js
pm2 save
pm2 startup
```

### مرحله ۵: تنظیم Nginx
```bash
# ساخت فایل کانفیگ
sudo nano /etc/nginx/sites-available/archive-manager
```

محتوای فایل:
```nginx
server {
    listen 80;
    server_name yourdomain.com www.yourdomain.com;

    location / {
        proxy_pass http://localhost:3000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
        proxy_cache_bypass $http_upgrade;
    }
}
```

فعال کردن سایت:
```bash
sudo ln -s /etc/nginx/sites-available/archive-manager /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl restart nginx
```

---

## 🎯 **روش ۳: Hostinger Cloud Hosting (مدرن)**

### مرحله ۱: استفاده از Docker
Hostinger Cloud از Docker پشتیبانی می‌کند:

#### ساخت Dockerfile:
```dockerfile
FROM node:18-alpine

WORKDIR /app

COPY package*.json ./
RUN npm ci --only=production

COPY . .
RUN npm run build

EXPOSE 3000

CMD ["npm", "start"]
```

#### ساخت docker-compose.yml:
```yaml
version: '3.8'
services:
  app:
    build: .
    ports:
      - "3000:3000"
    environment:
      - NODE_ENV=production
    restart: unless-stopped
```

#### اجرا:
```bash
docker-compose up -d
```

---

## 🎯 **روش ۴: نسخه استاتیک (ساده‌ترین)**

### مرحله ۱: تنظیم next.config.js
```javascript
/** @type {import('next').NextConfig} */
const nextConfig = {
  output: 'export',
  trailingSlash: true,
  images: {
    unoptimized: true
  },
  assetPrefix: '/archive-manager',
  basePath: '/archive-manager'
}

module.exports = nextConfig
```

### مرحله ۲: ساخت نسخه استاتیک
```bash
npm run build
npm run export
```

### مرحله ۳: آپلود روی Hostinger
```
1. وارد Hostinger hPanel شوید
2. File Manager را باز کنید
3. به public_html بروید
4. پوشه archive-manager بسازید
5. تمام محتویات پوشه out را آپلود کنید
```

### مرحله ۴: تست
```
به آدرس yourdomain.com/archive-manager بروید
```

---

## 🔧 **مشکلات رایج Hostinger و راه‌حل‌ها**

### مشکل ۱: "Node.js not supported"
```
راه‌حل: از نسخه استاتیک استفاده کنید
یا پلن خود را به Business ارتقا دهید
```

### مشکل ۲: "Port 3000 blocked"
```bash
# در next.config.js پورت تغییر دهید
const nextConfig = {
  port: 3001,
  // تنظیمات دیگر
}
```

### مشکل ۳: "Build failed - memory limit"
```bash
# در package.json تغییر دهید:
"scripts": {
  "build": "NODE_OPTIONS='--max-old-space-size=2048' next build"
}
```

### مشکل ۴: "API routes not working"
```
راه‌حل: در نسخه استاتیک API ها کار نمی‌کنند
باید از نسخه کامل Node.js استفاده کنید
```

---

## 🎯 **پیشنهاد نهایی من برای Hostinger**

### اگر Business Hosting دارید:
✅ **روش ۱** - استفاده از Node.js Manager
- بهترین عملکرد
- تمام ویژگی‌ها کار می‌کند
- ساده‌ترین راه

### اگر VPS دارید:
✅ **روش ۲** - نصب دستی با PM2
- کنترل کامل
- بهترین بهینه‌سازی
- حرفه‌ای‌ترین راه

### اگر Shared Hosting دارید:
✅ **روش ۴** - نسخه استاتیک
- تنها راه ممکن
- محدودیت‌ها دارد
- برای نمایش مناسب است

### اگر Cloud Hosting دارید:
✅ **روش ۳** - استفاده از Docker
- مدرن و قدرتمند
- مقیاس‌پذیر
- حرفه‌ای

---

## 📋 **چک‌لیست نصب روی Hostinger**

### ✅ **برای Business Hosting:**
- [ ] Node.js Manager در hPanel وجود دارد
- [ ] نسخه Node.js 18+ انتخاب شده
- [ ] دیپندنسی‌ها نصب شده‌اند
- [ ] پروژه با موفقیت بیلد شده
- [ ] برنامه در حال اجرا است
- [ ] سایت در مرورگر باز می‌شود

### ✅ **برای VPS:**
- [ ] SSH اتصال موفق است
- [ ] Node.js و PM2 نصب شده‌اند
- [ ] Nginx تنظیم شده است
- [ ] پروژه آپلود و اجرا شده
- [ ] SSL Certificate نصب شده
- [ ] سایت با HTTPS کار می‌کند

### ✅ **برای نسخه استاتیک:**
- [ ] next.config.js تنظیم شده
- [ ] پروژه با موفقیت export شده
- [ ] فایل‌ها در public_html آپلود شده‌اند
- [ ] سایت در مرورگر باز می‌شود

---

## 🎊 **نتیجه‌گیری**

**بهترین راه حل برای شما بستگی به نوع هاستینگ Hostinger شما دارد:**

### 🏆 **Business Hosting:** روش ۱ (Node.js Manager)
### 🚀 **VPS Hosting:** روش ۲ (PM2 + Nginx)
### 🌟 **Cloud Hosting:** روش ۳ (Docker)
### 📄 **Shared Hosting:** روش ۴ (استاتیک)

### **پیشنهاد کلی من:**
اگر Business Hosting ندارید، **به VPS ارتقا دهید** یا **از Vercel استفاده کنید** چون:
- کنترل کامل دارید
- تمام ویژگی‌ها کار می‌کند
- قیمت مناسب‌تری دارد
- برای رشد مناسب‌تر است

**موفق باشید!** 🎉

اگر نوع هاستینگ خود را بگویید، می‌توانم راهنمایی دقیق‌تری بدهم!