# 🚀 راهنمای قدم به قدم نصب و اجرا روی هاست واقعی

## 📋 پیش‌نیازهای اولیه

### ۱. هاست مورد نیاز:
- **Node.js 18+** یا هاست با پشتیبانی Node.js
- **MySQL/MariaDB** یا SQLite (برای شروع SQLite ساده‌تر است)
- **SSL Certificate** (برای HTTPS)
- **Domain Name** (اختیاری ولی توصیه می‌شود)

### ۲. انواع هاست‌های مناسب:
- ✅ **VPS/Dedicated Server** (بهترین گزینه)
- ✅ **Cloud Hosting** (DigitalOcean, Vultr, Linode)
- ✅ **Node.js Hosting** (Heroku, Vercel, Netlify)
- ❌ **Shared Hosting** (معمولاً پشتیبانی نمی‌شود)

---

## 🎯 روش ۱: VPS/Dedicated Server (بهترین روش)

### مرحله ۱: آماده‌سازی سرور
```bash
# آپدیت سرور
sudo apt update && sudo apt upgrade -y

# نصب Node.js 18
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# نصب PM2 (Process Manager)
sudo npm install -g pm2

# نصب Nginx (برای reverse proxy)
sudo apt install nginx -y

# نصب Certbot (برای SSL)
sudo apt install certbot python3-certbot-nginx -y
```

### مرحله ۲: آپلود پروژه
```bash
# کلون پروژه از گیت‌هاب
git clone <your-repo-url>
cd archive-manager-nextjs

# یا آپلود دستی با SCP
scp -r ./archive-manager-nextjs user@your-server:/var/www/

# نصب دیپندنسی‌ها
npm install
```

### مرحله ۳: تنظیمات محیطی
```bash
# ایجاد فایل .env.production
nano .env.production
```

محتوای فایل `.env.production`:
```env
NODE_ENV=production
NEXTAUTH_URL=https://yourdomain.com
API_KEY=your-secret-api-key-here
DATABASE_URL=sqlite:./data/archive.db
ENCRYPTION_KEY=your-32-character-encryption-key
ALLOWED_ORIGINS=https://yourdomain.com
```

### مرحله ۴: ساخت پروژه برای پروداکشن
```bash
# ساخت پروژه
npm run build

# تست پروژه در حالت پروداکشن
npm start
```

### مرحله ۵: راه‌اندازی با PM2
```bash
# ایجاد فایل PM2 config
nano ecosystem.config.js
```

محتوای `ecosystem.config.js`:
```javascript
module.exports = {
  apps: [{
    name: 'archive-manager',
    script: 'npm',
    args: 'start',
    cwd: '/var/www/archive-manager-nextjs',
    instances: 'max',
    exec_mode: 'cluster',
    env: {
      NODE_ENV: 'production',
      PORT: 3000
    },
    error_file: './logs/err.log',
    out_file: './logs/out.log',
    log_file: './logs/combined.log',
    time: true
  }]
};
```

راه‌اندازی با PM2:
```bash
# ساخت پوشه لاگ‌ها
mkdir logs

# استارت با PM2
pm2 start ecosystem.config.js

# ذخیره کردن PM2 config
pm2 save

# استارت اتوماتیک بعد از ریبوت
pm2 startup
```

### مرحله ۶: تنظیم Nginx
```bash
# ایجاد فایل کانفیگ Nginx
sudo nano /etc/nginx/sites-available/archive-manager
```

محتوای فایل Nginx:
```nginx
server {
    listen 80;
    server_name yourdomain.com www.yourdomain.com;

    location / {
        proxy_pass http://localhost:3000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
        proxy_cache_bypass $http_upgrade;
    }
}
```

فعال کردن سایت:
```bash
# فعال کردن سایت
sudo ln -s /etc/nginx/sites-available/archive-manager /etc/nginx/sites-enabled/

# تست کانفیگ Nginx
sudo nginx -t

# ریستارت Nginx
sudo systemctl restart nginx
```

### مرحله ۷: نصب SSL Certificate
```bash
# دریافت SSL رایگان از Let's Encrypt
sudo certbot --nginx -d yourdomain.com -d www.yourdomain.com

# ریستارت اتوماتیک SSL
sudo systemctl enable certbot.timer
```

---

## 🎯 روش ۲: Vercel (ساده‌ترین روش)

### مرحله ۱: آماده‌سازی پروژه
```bash
# نصب Vercel CLI
npm install -g vercel

# لاگین به Vercel
vercel login
```

### مرحله ۲: ساخت و دیپلوی
```bash
# ساخت پروژه
npm run build

# دیپلوی روی Vercel
vercel --prod
```

### مرحله ۳: تنظیمات محیطی در Vercel
1. وارد داشبورد Vercel شوید
2. پروژه خود را انتخاب کنید
3. به تب Settings بروید
4. Environment Variables را باز کنید
5. متغیرهای زیر را اضافه کنید:
   - `NODE_ENV=production`
   - `API_KEY=your-secret-key`
   - `ENCRYPTION_KEY=your-32-char-key`

---

## 🎯 روش ۳: DigitalOcean App Platform

### مرحله ۱: آماده‌سازی پروژه
```bash
# ایجاد فایل DO app spec
nano .do/app.yaml
```

محتوای `.do/app.yaml`:
```yaml
name: archive-manager
services:
- name: web
  source_dir: /
  github:
    repo: your-username/archive-manager-nextjs
    branch: main
  run_command: npm start
  environment_slug: node-js
  instance_count: 1
  instance_size_slug: basic-xxs
  env:
  - key: NODE_ENV
    value: production
  - key: API_KEY
    value: your-secret-key
  http_port: 3000
  routes:
  - path: /
```

### مرحله ۲: دیپلوی
1. وارد DigitalOcean Control Panel شوید
2. Apps را انتخاب کنید
3. Create App را بزنید
4. ریپازیتوری گیت‌هاب را متصل کنید
5. فایل `.do/app.yaml` را انتخاب کنید
6. Deploy را بزنید

---

## 🎯 روش ۴: Heroku

### مرحله ۱: آماده‌سازی پروژه
```bash
# نصب Heroku CLI
# برای Ubuntu/Debian
sudo snap install heroku --classic

# لاگین به Heroku
heroku login

# ایجاد اپلیکیشن
heroku create your-app-name
```

### مرحله ۲: ساخت و دیپلوی
```bash
# ساخت پروژه
npm run build

# اضاف کردن buildpack
heroku buildpacks:set heroku/nodejs

# دیپلوی
git push heroku main
```

### مرحله ۳: تنظیمات محیطی
```bash
# تنظیم متغیرهای محیطی
heroku config:set NODE_ENV=production
heroku config:set API_KEY=your-secret-key
heroku config:set ENCRYPTION_KEY=your-32-char-key
```

---

## 🔧 تنظیمات دیتابیس (اختیاری)

### استفاده از SQLite (ساده)
```bash
# نصب sqlite3
npm install sqlite3

# ایجاد پوشه دیتابیس
mkdir data

# ساخت دیتابیس
node -e "const sqlite3 = require('sqlite3'); const db = new sqlite3('./data/archive.db'); db.close();"
```

### استفاده از MySQL (پیشرفته)
```bash
# نصب MySQL
sudo apt install mysql-server -y

# ساخت دیتابیس
sudo mysql -u root -p
CREATE DATABASE archive_manager;
CREATE USER 'archiveuser'@'localhost' IDENTIFIED BY 'strongpassword';
GRANT ALL PRIVILEGES ON archive_manager.* TO 'archiveuser'@'localhost';
FLUSH PRIVILEGES;
EXIT;
```

---

## 🛡️ تنظیمات امنیتی

### ۱. فایروال
```bash
# تنظیم فایروال UFW
sudo ufw allow ssh
sudo ufw allow 'Nginx Full'
sudo ufw enable
```

### ۲. امنیت Node.js
```bash
# ایجاد کاربر غیر روت
sudo adduser nodeapp
sudo chown -R nodeapp:nodeapp /var/www/archive-manager-nextjs
```

### ۳. بکاپ‌گیری اتوماتیک
```bash
# ایجاد اسکریپت بکاپ
nano backup.sh
```

محتوای `backup.sh`:
```bash
#!/bin/bash
DATE=$(date +%Y%m%d_%H%M%S)
BACKUP_DIR="/var/backups/archive-manager"
mkdir -p $BACKUP_DIR

# بکاپ از دیتابیس
mysqldump -u archiveuser -p archive_manager > $BACKUP_DIR/db_$DATE.sql

# بکاپ از فایل‌ها
tar -czf $BACKUP_DIR/files_$DATE.tar.gz /var/www/archive-manager-nextjs

# حذف بکاپ‌های قدیمی (۷ روز)
find $BACKUP_DIR -name "*.sql" -mtime +7 -delete
find $BACKUP_DIR -name "*.tar.gz" -mtime +7 -delete
```

```bash
# اجرای اتوماتیک بکاپ روزانه
chmod +x backup.sh
echo "0 2 * * * /path/to/backup.sh" | crontab -
```

---

## 📊 مانیتورینگ و نگهداری

### ۱: مانیتورینگ با PM2
```bash
# مشاهده وضعیت برنامه‌ها
pm2 status

# مشاهده لاگ‌ها
pm2 logs

# ریستارت برنامه
pm2 restart archive-manager

# آپدیت برنامه
pm2 reload archive-manager
```

### ۲: مانیتورینگ سرور
```bash
# نصب htop
sudo apt install htop -y

# مشاهده منابع
htop

# مشاهده دیسک
df -h

# مشاهده حافظه
free -h
```

---

## 🚨 عیب‌یابی رایج

### ۱: خطای Port 3000
```bash
# بررسی پورت‌های باز
sudo netstat -tlnp | grep :3000

# کشتن پروسه‌های قدیمی
sudo pkill -f node
```

### ۲: خطای Permission
```bash
# تنظیم مجوزها
sudo chown -R $USER:$USER /var/www/archive-manager-nextjs
chmod -R 755 /var/www/archive-manager-nextjs
```

### ۳: خطای Memory
```bash
# افزایش swap
sudo fallocate -l 2G /swapfile
sudo chmod 600 /swapfile
sudo mkswap /swapfile
sudo swapon /swapfile
```

---

## 📱 تست نهایی

### چک‌لیست تست:
- [ ] سایت با HTTPS باز می‌شود
- [ ] تمام API ها کار می‌کنند
- [ ] ورود/خروج CSV عمل می‌کند
- [ ] فونت وزیر به درستی نمایش داده می‌شود
- [ ] روی موبایل به درستی کار می‌کند
- [ ] SSL Certificate معتبر است
- [ ] بکاپ‌گیری کار می‌کند

---

## 🎉 نتیجه‌گیری

پس از انجام این مراحل، سیستم شما روی هاست واقعی با آدرس دامنه‌تان قابل دسترس خواهد بود. **روش VPS** بهترین عملکرد را دارد ولی **روش Vercel** ساده‌ترین راه برای شروع است.

### توصیه نهایی:
1. **برای شروع**: از Vercel استفاده کنید
2. **برای پروداکشن**: از VPS با Nginx استفاده کنید
3. **همیشه**: از SSL و بکاپ‌گیری استفاده کنید

موفق باشید! 🚀