# 🎯 راهنمای سریع نصب روی cPanel

## 🚀 **سریع‌ترین راه برای cPanel**

### **مرحله ۱: بررسی cPanel شما (۱ دقیقه)**
1. وارد cPanel شوید
2. دنبال **"Setup Node.js App"** بگردید
3. اگر پیدا کردید → **روش ۱** را بروید
4. اگر پیدا نکردید → **روش ۲** را بروید

---

## 🎯 **روش ۱: اگر Node.js Selector دارید**

### مرحله ۱: ساخت اپلیکیشن Node.js
```
cPanel → Setup Node.js App → Create Application
```

### تنظیمات:
```
Node.js version: 18.x
Application mode: Production
Application root: archive-manager
Application URL: /archive-manager
Application startup file: package.json
```

### مرحله ۲: آپلود فایل‌ها
```
1. وارد File Manager شوید
2. به پوشه archive-manager بروید
3. تمام فایل‌های پروژه را آپلود کنید
4. دکمه "Extract" را بزنید
```

### مرحله ۳: نصب دیپندنسی‌ها
```
در cPanel → Setup Node.js App:
1. پروژه خود را پیدا کنید
2. دکمه "Run NPM Install" را بزنید
3. صبر کنید تا نصب تمام شود
```

### مرحله ۴: ساخت و اجرا
```
1. دکمه "Run NPM Build" را بزنید
2. دکمه "Restart" را بزنید
3. به آدرس yourdomain.com/archive-manager بروید
```

---

## 🎯 **روش ۲: اگر Node.js Selector ندارید**

### مرحله ۱: تبدیل به استاتیک
در فایل `next.config.js` این کد را اضافه کنید:
```javascript
/** @type {import('next').NextConfig} */
const nextConfig = {
  output: 'export',
  trailingSlash: true,
  images: {
    unoptimized: true
  }
}

module.exports = nextConfig
```

### مرحله ۲: ساخت نسخه استاتیک
```bash
# در کامپیوتر خودتان:
npm run build
npm run export
```

### مرحله ۳: آپلود روی cPanel
```
1. وارد File Manager شوید
2. به public_html بروید
3. پوشه جدید بسازید به نام archive-manager
4. تمام محتویات پوشه out را آپلود کنید
```

### مرحله ۴: تست
```
به آدرس yourdomain.com/archive-manager بروید
```

---

## 🔧 **اگر خطایی دیدید:**

### خطا: "Node.js not found"
```
راه‌حل: از روش ۲ (استاتیک) استفاده کنید
```

### خطا: "Port 3000 blocked"
```
راه‌حل: در next.config.js پورت تغییر دهید
```

### خطا: "Build failed"
```
راه‌حل: از ورژن‌های پایین‌تر Node.js استفاده کنید
```

---

## 🎯 **پیشنهاد نهایی من**

### اگر cPanel شما مدرن است:
✅ **روش ۱** - تمام ویژگی‌ها کار می‌کند

### اگر cPanel شما قدیمی است:
✅ **روش ۲** - ساده و بدون دردسر

### اگر می‌خواهید بهترین نتیجه را بگیرید:
🚀 **Vercel** - رایگان و عالی

---

## 📞 **کمک بیشتر**

اگر سوالی داشتید:
1. نوع cPanel خود را بگویید
2. بگویید کدام خطا را می‌بینید
3. من راه‌حل دقیق به شما می‌دهم

**موفق باشید!** 🎉