# 🚀 راهنمای نصب روی cPanel (روش‌های مختلف)

## 🎯 **روش ۱: استفاده از Node.js Selector در cPanel (بهترین روش)**

### مرحله ۱: بررسی پشتیبانی Node.js در cPanel شما
1. وارد cPanel شوید
2. دنبال **"Setup Node.js App"** یا **"Node.js Selector"** بگردید
3. اگر پیدا کردید، این بهترین روش برای شماست!

### مرحله ۲: اگر Node.js Selector دارید:
```bash
# 1. در cPanel:
# Setup Node.js App → Create Application

# 2. تنظیمات:
# Node.js version: 18.x یا بالاتر
# Application mode: Production
# Application root: archive-manager
# Application URL: /archive-manager
# Application startup file: package.json
```

### مرحله ۳: آپلود فایل‌ها
```bash
# 1. پروژه را در پوشه archive-manager آپلود کنید
# 2. از طریق File Manager یا FTP

# 3. نصب دیپندنسی‌ها:
# در cPanel → Node.js Selector → Run NPM Install
```

### مرحله ۴: ساخت و اجرا
```bash
# 1. در cPanel → Node.js Selector:
# Run NPM Build

# 2. فایل start.js ایجاد کنید:
const { createServer } = require('http')
const next = require('next')

const dev = process.env.NODE_ENV !== 'production'
const app = next({ dev })
const handle = app.getRequestHandler()

app.prepare().then(() => {
  createServer((req, res) => {
    handle(req, res)
  }).listen(3000, (err) => {
    if (err) throw err
    console.log('> Ready on http://localhost:3000')
  })
})
```

---

## 🎯 **روش ۲: استفاده از SSH (اگر دسترسی دارید)**

### مرحله ۱: اتصال SSH
```bash
ssh username@yourdomain.com
```

### مرحله ۲: نصب Node.js
```bash
# بررسی نسخه Node.js
node --version

# اگر نصب نبود:
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs
```

### مرحله ۳: آپلود و اجرا
```bash
# 1. آپلود پروژه
cd /home/username/public_html
git clone your-repo

# 2. نصب دیپندنسی‌ها
cd archive-manager
npm install

# 3. ساخت پروژه
npm run build

# 4. اجرا با PM2
npm install -g pm2
pm2 start npm --name "archive-manager" -- start
pm2 save
pm2 startup
```

---

## 🎯 **روش ۳: تبدیل به استاتیک (ساده‌ترین روش)**

### مرحله ۱: ساخت نسخه استاتیک
```bash
# 1. در پروژه محلی:
npm run build

# 2. خروجی استاتیک در پوشه .next قرار دارد
# 3. پوشه out را ایجاد کنید:
npm install next export
```

### مرحله ۲: تنظیم next.config.js
```javascript
/** @type {import('next').NextConfig} */
const nextConfig = {
  output: 'export',
  trailingSlash: true,
  images: {
    unoptimized: true
  }
}

module.exports = nextConfig
```

### مرحله ۳: ساخت نسخه استاتیک
```bash
npm run build
npm run export
```

### مرحله ۴: آپلود روی cPanel
```bash
# 1. پوشه out را به public_html/archive-manager آپلود کنید
# 2. تمام فایل‌ها را آپلود کنید
# 3. به آدرس yourdomain.com/archive-manager بروید
```

---

## 🎯 **روش ۴: استفاده از پلاگین cPanel**

### مرحله ۱: نصب پلاگین Node.js
1. وارد WHM شوید (اگر دسترسی دارید)
2. به **Install a Plugin** بروید
3. پلاگین Node.js را نصب کنید

### مرحله ۲: تنظیمات
```bash
# در cPanel:
# Software → Node.js → Create Application
```

---

## 🎯 **روش ۵: استفاده از سرویس‌های میزبانی Node.js**

### گزینه ۱: Vercel (توصیه من)
```bash
# 1. پروژه را روی گیت‌هاب آپلود کنید
# 2. به vercel.com بروید
# 3. با گیت‌هاب لاگین کنید
# 4. پروژه را انتخاب کنید
# 5. دیپلوی کنید
```

### گزینه ۲: Netlify
```bash
# 1. پروژه را به استاتیک تبدیل کنید
# 2. به netlify.com بروید
# 3. با گیت‌هاب متصل شوید
# 4. دیپلوی کنید
```

### گزینه ۳: Heroku
```bash
# 1. نصب Heroku CLI
npm install -g heroku

# 2. لاگین
heroku login

# 3: ساخت اپلیکیشن
heroku create your-app-name

# 4: دیپلوی
git push heroku main
```

---

## 🎯 **روش ۶: استفاده از Docker (اگر پشتیبانی می‌کند)**

### مرحله ۱: ایجاد Dockerfile
```dockerfile
FROM node:18-alpine

WORKDIR /app

COPY package*.json ./
RUN npm ci --only=production

COPY . .
RUN npm run build

EXPOSE 3000

CMD ["npm", "start"]
```

### مرحله ۲: ساخت و اجرا
```bash
# 1. ساخت ایمیج
docker build -t archive-manager .

# 2. اجرا
docker run -p 3000:3000 archive-manager
```

---

## 🔧 **مشکلات رایج و راه‌حل‌ها**

### مشکل ۱: "Node.js not found"
```bash
# راه‌حل: از روش استاتیک استفاده کنید
# یا از هاست دیگری استفاده کنید که Node.js پشتیبانی می‌کند
```

### مشکل ۲: "Port 3000 blocked"
```bash
# راه‌حل: در next.config.js پورت را تغییر دهید
const nextConfig = {
  port: 3001, // یا پورت دیگری
}
```

### مشکل ۳: "Build failed"
```bash
# راه‌حل: نسخه استاتیک استفاده کنید
npm run export
```

---

## 🎯 **پیشنهاد نهایی من برای cPanel**

### اگر cPanel شما Node.js پشتیبانی می‌کند:
1. ✅ **روش ۱** را استفاده کنید (Node.js Selector)
2. بهترین عملکرد را دارد
3. تمام ویژگی‌ها کار می‌کند

### اگر cPanel شما Node.js پشتیبانی نمی‌کند:
1. ✅ **روش ۳** را استفاده کنید (استاتیک)
2. ساده‌ترین راه است
3. برخی ویژگی‌ها محدود می‌شوند

### بهترین راه حل کلی:
1. 🚀 **Vercel** را استفاده کنید
2. رایگان و سریع است
3. هیچ دردسری ندارد
4. تمام ویژگی‌ها کار می‌کند

---

## 📋 **چک‌لیست نصب روی cPanel**

### ✅ **برای روش Node.js Selector:**
- [ ] Node.js Selector در cPanel وجود دارد
- [ ] نسخه Node.js 18+ انتخاب شده
- [ ] دیپندنسی‌ها نصب شده‌اند
- [ ] پروژه با موفقیت بیلد شده
- [ ] برنامه در حال اجرا است

### ✅ **برای روش استاتیک:**
- [ ] next.config.js تنظیم شده
- [ ] پروژه با موفقیت export شده
- [ ] فایل‌ها در public_html آپلود شده‌اند
- [ ] سایت در مرورگر باز می‌شود

---

## 🎊 **نتیجه‌گیری**

**بهترین راه حل برای شما:**

1. **اگر cPanel شما مدرن است:** از Node.js Selector استفاده کنید
2. **اگر cPanel شما قدیمی است:** از نسخه استاتیک استفاده کنید
3. **اگر می‌خواهید بهترین نتیجه را بگیرید:** از Vercel استفاده کنید

**پیشنهاد من:** 🚀 **Vercel** چون:
- رایگان است
- ۱۰ دقیقه راه‌اندازی می‌شود
- تمام ویژگی‌ها کار می‌کند
- هیچ دردسری ندارد

**موفق باشید!** 🎉